<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\User\Block;

use Erlage\Photogram\Data\Models\AbstractFinder;
use Erlage\Photogram\Data\Tables\User\UserBlockTable;

final class UserBlockFinder extends AbstractFinder implements InterfaceUserBlockSetter
{
    /**
     * setter interface
     */
    use TraitUserBlockSetters;

    public function getTableName(): string
    {
        return UserBlockTable::getTableName();
    }

    /**
     * @return mixed 
     */
    public function getAtrributeValue(string $attribute)
    {
        return $this -> {UserBlockTable::CAMEL_CASE_MAP[$attribute]}
        ?? null;
    }

    public function popModelFromResults(): UserBlockModel
    {
        return UserBlockModel::createFromUntouchedBean_noException(parent::pop());
    }
}
